#Visa Sensory Branding - iOS SDK Integration

## Prerequisite
The .xcframework will work with 

- iOS 13 or above
- Xcode 13 or above
- Swift 5.5 or above

## Demo App

1. To run demo app, please install [CocoaPods](https://cocoapods.org/).
2. Run ```pod install``` in "VisaSensoryBrandingDemo" where ```Podfile``` is.
3. Open the VisaSensoryBranding workspace and run the active scheme.
4. Select the options to test for in the main screen and press the play button on the top right to see the logo animation.

## Integration

1. Download VisaSensoryBranding.xcframework file.
2. Drag and drop VisaSensoryBranding.framework into Embedded Binaries section of Project. (Leave "Copy items if needed" checked.)

<img src="media/draft_step_3.png" width="180"/>

<img src="media/draft_step_4.png" width="380"/>

<img src="media/draft_step_5.png" width="400"/> 

3\. Change "Do not embed" to "Embed & Sign"

### View Integration

Please see the integration examples under below folders inside the package.

<img src="media/view_integration.png"/> 

### Sizing and layout  

You can choose to have the Visa animation render in full screen on a device, or in a constrained view in context of other UI elements. To render in full screen, simply initialize the container to fit device height and width and set background color to same as ```backdropColor```. For constrained view, specify the width of ```SensoryBrandingView``` during initialization. 

- The width of the animation object will not be larger than 60% of the screen's width. If the width is set to be larger, it will be resized to be 60% of the screen's width. 

- The width of the animation object will not be smaller than 20% of the screen's width. If the width is set to be smaller, it will be resized to be 20% of the screen's width. 

### Usage

Import the Visa Sensory Branding library into any source files as necessary.

Swift:

``` swift
import SensoryBrandingView
```

ObjC:

```
#import "VisaSensoryBranding/VisaSensoryBranding-Swift.h"
```

### Initialization

Swift:

``` swift
let sensoryBrandingView = SensoryBranding()
self.view.addSubview(sensoryBrandingView)
```
SwiftUI:

```
func makeUIView(context: Context) -> SensoryBranding {
    SensoryBranding()
}
```

ObjC:

```
SensoryBranding * sb = [SensoryBranding new];
    [[self view] addSubview: sb];
```

### Animate

Activates the Visa Sensory Branding animation.

Swift:

```swift
sensoryBrandingView.animate { result, error in
  // handling code
}
```

ObjC:

```
[sb animateWithCompletion:^(BOOL, NSError * err) {
    printf("error: %s", err);
}];
```

The error message includes 4 scenarios:

1. .animationInProgress ("Animation is in progress")
2. .fileNotFound ("File not found: (file name)")
3. .unexpected ("Unexpected error : (error details)")
4. .invalidColor ("Invalid background color selected, contrast levels are below 3:1 against #FFFFFF and #1434CB")

## Animation Configuration Parameters

### Language Code

Define the language of the texts present below the checkmark.

Swift & ObjC:

``` swift
sensoryBrandingView.languageCode = "en"
```

Please refer to “Available language codes for integration” table under Appendix section. 

### Backdrop Color

The color behind the animation, used to determine the Visa logo colors. Specify Visa Blue(#1434CB) for a white Visa logo. Specify White(#FFFFFF) for a blue Visa logo. Any other color will result in either blue or white color applied to the Logo, depending on contrast.

**Note:** Do not set backdropColor to clear, will default to Visa Blue if done so.

Swift:

```swift
sensoryBrandingView.backdropColor = .black
```

ObjC:

```
sensoryBrandingView.backdropColor = [UIColor blackColor];
```

### Sound

Set to true to enable sound. (true by default)

Swift & ObjC:

```swift
sensoryBrandingView.isSoundEnabled = true
```

### Haptic Feedback

Set to true to enable haptic feedback. (true by default)

Swift & ObjC:

``` Swift
sensoryBrandingView.isHapticFeedbackEnabled = true
```

### Checkmark

This parameter enables/disables checkmark screen after visa logo animation 
 
Example: 

- "checkmark": shows checkmark at the end of the animation without text (default)
- "checkmarkWithText": shows checkmark and checkmark text at the end of the animation 
- "none": no checkmark at the end of the animation 

Swift: 

```swift
sensoryBrandingView.checkmarkMode = .checkmarkWithText
sensoryBrandingView.checkmarkTextOption = .success
```
Objc:

```
sensoryBrandingView.checkmarkMode = CheckmarkModeCheckmarkWithText
sensoryBrandingView.checkmarkTextOptionForObjc = CheckmarkTextOptionForObjcComplete
```

Checkmark text includes:

- .success (default)
- .approve
- .complete

## Migration Steps for Existing Users

1. Replace existing SDK, refer to Requirements above.
2. Migrate existing configurations in the table below.

|Option|Original|New changes|
|:--:|:--:|:--:|
|Backdrop Color|```backdropColor: String```|```backdropColor: UIColor```|
|Checkmark options|```isCheckmarkShown: boolean```|```checkmarkMode: enum```<br>```checkmarkTextOption: enum```<br>```checkmarkTextOptionForObjc: enum //ObjC```|
|Constrained Flags|```hasConstrainedFlags: boolean ```|Obsolesced|
|Language Code|N/A|```languageCode: String //e.g. "en" ```|


## Appendix

### Available language codes for integration

Please refer https://support.apple.com/en-us/HT206175 for languages supported by VoiceOver.

|Language Name|Language Code|
|:--:|:--:|
| English | en | Y |
| Arabic| ar | Y |
| Azeri | az |
| Bahasa Indonesia | id |
| Bosnian | bs |
| Bulgarian | bg |
| Canadian English | en_ca |  Y |
| Canadian French | fr_ca | Y |
| Croatian | hr |
| Czech | cs | Y |
| Danish | da | Y |
| Dutch | nl | Y |
| Finnish | fi | Y |
| French | fr | Y |
| Georgian | ka |
| German | de | Y |
| Greek | el | Y |
| Hebrew | he | Y |
| Hungarian | hu | Y |
| Icelandic | is |
| Italian | it | Y |
| Latvian | lv |
| Lithuanian | lt |
| Japanese | ja | Y |
| Kazakh | kk |
| Khmer | km |
| Kinyarwanda | rw |
| Korean | ko | Y |
| Mongolian | mn |
| Norwegian | no | Y |
| Polish | pl | Y |
| Portuguese (Brazilian) | pt_br | Y |
| Portuguese (Regular) | pt | Y |
| Romanian | ro | Y |
| Russian | ru | Y |
| Serbian | sr |
| Simplified Chinese | zh_cn | Y |
| Slovakian | sk | Y |
| Slovenian | sl |
| Spanish (AR) | es_ar |
| Spanish (MX) | es_mx | Y |
| Spanish (LA) | es_la|
| Spanish (ES) | es | Y |
| Swedish | sv | Y |
| Thai | th | Y |
| Traditional Chinese (HK) | zh_hk | Y |
| Traditional Chinese (TW) | zh_tw | Y |
| Turkish | tr | Y |
| UK English | en_gb | Y |
| Ukrainian | ua |
| Vietnamese | vi |
