//
//  ViewController.m
//  TestMSMObjectiveC
//

#import "ViewController.h"
#import "VisaSensoryBranding/VisaSensoryBranding-Swift.h" // Step 0: import the VisaSensoryBranding-Swift.h


@interface ViewController ()

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Step 1: Initialize the SensoryBranding view (size & layout).
    SensoryBranding * sb = [SensoryBranding new];
    [[self view] addSubview: sb];
    CGRect frame = sb.frame;
    frame.size.width = 200;
    sb.frame = frame;
    sb.center = [[self view] convertPoint:[self view].center fromView: [self view].superview];
    
    // Step 2: Config params of SensoryBranding view.
    sb.isSoundEnabled = true;
    sb.isHapticFeedbackEnabled = true;
    sb.languageCode = @"en";
    sb.backdropColor = [UIColor blackColor];
    sb.checkmarkMode = CheckmarkModeCheckmarkWithText;
    sb.checkmarkTextOptionForObjc = CheckmarkTextOptionForObjcApprove;

    // Step 3: Trigger the animation.
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 1 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
        [sb animateWithCompletion:^(BOOL, NSError * err) {
            printf("error: %s", err);
        }];
    });
    
}

@end
