//
//  ContentView.swift
//  testswifttui
//

import SwiftUI
import VisaSensoryBranding

struct ContentView: View {
    var body: some View {
        VStack(alignment: .leading, spacing: 0) {
            SensoryBrandingSwiftUI()
                .frame(width: 240, height: 300)
        }
    }
}
struct SensoryBrandingSwiftUI: UIViewRepresentable {

    func makeUIView(context: Context) -> SensoryBranding {
        SensoryBranding()
    }

    func updateUIView(_ sensoryBrandingView: SensoryBranding, context: Context) {
        sensoryBrandingView.languageCode = "en"
        sensoryBrandingView.backdropColor = .black
        sensoryBrandingView.isSoundEnabled = true
        sensoryBrandingView.isHapticFeedbackEnabled = true
        sensoryBrandingView.checkmarkMode = .checkmarkWithText
        sensoryBrandingView.checkmarkTextOption = .approve
        DispatchQueue.main.asyncAfter(deadline: .now() + 1.0) {
            sensoryBrandingView.animate()
        }
    }
    
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
