//
//  ViewController.swift
//  test3
//

import UIKit
import VisaSensoryBranding

class ViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Step 1: Initialize the SensoryBranding view (size & layout).
        let sensoryBrandingView = SensoryBranding()
        self.view.addSubview(sensoryBrandingView)
        sensoryBrandingView.translatesAutoresizingMaskIntoConstraints = false
        sensoryBrandingView.centerXAnchor
            .constraint(equalTo: self.view.centerXAnchor)
            .isActive = true
        sensoryBrandingView.centerYAnchor
            .constraint(equalTo: self.view.centerYAnchor)
            .isActive = true
        sensoryBrandingView.widthAnchor
            .constraint(equalTo: self.view.widthAnchor)
            .isActive = true
        
        // Step 2: Config params of SensoryBranding view.
        sensoryBrandingView.languageCode = "en"
        sensoryBrandingView.backdropColor = .black
        sensoryBrandingView.isSoundEnabled = true
        sensoryBrandingView.isHapticFeedbackEnabled = true
        sensoryBrandingView.checkmarkMode = .checkmarkWithText
        sensoryBrandingView.checkmarkTextOption = .approve
        
        
        // Step 3: trigger the animation.
        DispatchQueue.main.asyncAfter(deadline: .now() + 1.0) {
            sensoryBrandingView.animate { result, error in
                print(result)
                print(error ?? "No error")
            }
        }
    }


}

