//
//  AnimationParameters.swift
//  VisaSensoryBrandingDemo
//

import Foundation
import VisaSensoryBranding
import UIKit

public enum CheckmarkTextUIOptions: Int{
    case none = 0
    case approve = 1
    case success = 2
    case complete = 3
}

/**
 * To make it easier to retain and pass all required values to VSB instance.
 */
struct AnimationParameters {
    public var langCode: String
    public var backgroundColor: UIColor
    public var enableAudio: Bool
    public var enableHaptics: Bool
    public var enableCheckmark: Bool
    public var checkmarkText: CheckmarkTextUIOptions
}
