//
//  CheckMarkTextOptions.swift
//  VisaSensoryBrandingDemo
//

import Foundation
import UIKit

var langCodes: [String] = []
var languageDataSource: [String] = []
var checkmarkTextDataSource = ["None", "Approved", "Success", "Complete"] // Keep the same order for other languages

extension MainViewController: UIPickerViewDataSource, UIPickerViewDelegate {
    
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if (pickerView.tag == tagText) {
            return checkmarkTextDataSource.count
        } else {
            return languageDataSource.count
        }
    }
    
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if (pickerView.tag == tagText) {
            return checkmarkTextDataSource[row]
        } else {
            return languageDataSource[row]
        }
    }
    
}
