# Web SDK Technical Implementation 


## Demo Page
To view the demo page locally, you can follow the steps below:
1) Download [Node.js](https://nodejs.org/) 
2) Run ‘npm install http-server’ 
3) Run ‘http-server -p 8080’ 
4) Open http://localhost:8080/demo/index.html 

Alternatively, you can unzip the file and host the folder under any of the web server EG: https://domain-name/demo/index.html

## Integration 

+ Place the VisaSensoryBrandingSDK folder from the zip wherever you like
+ Import visa-sensory-branding.js in your page
```
<script src="./VisaSensoryBrandingSDK/visa-sensory-branding.js"></script>
```
+ Call VisaSensoryBranding.init() with desired configuration parameters for running the branding animation. Parameters are explained under "Animation Configuration Parameters" section.
```
<script>
  VisaSensoryBranding.init( {constrained: true}, './VisaSensoryBrandingSDK' );
</script>
```
+ Add an empty div with id "visa-sensory-branding". This is where the branding will display
```
<div id="visa-sensory-branding"></div>
```
+ •	Call VisaSensoryBranding.show() to run the branding animation
```
<script>
  VisaSensoryBranding.show();
</script>
```

### Animation End Event
When the animation ends, a CustomEvent object of type 'visa-sensory-branding-end' event is dispatched from the Dom Element. 

To add an event listener, please follow the code snippet below:
```
 window.addEventListener("message", e => {
    if (e.data === 'visa-sensory-branding-end') {
      console.log(e);
    }
 });
 ```
This event listener is useful for third-party confirmation page integration. You can trigger a redirect event to your third-party confirmation page. Please refer to ‘documentation/full-screen-with-third-party-checkmark.html’ for more examples. 

## View Integration

To view it on the local machine, please render it on localhost or any web server.

**Constrained View**:
+ http://localhost:8080/documentation/static.html
+ http://localhost:8080/documentation/absolute.html

**Full Screen View with Checkmark**:
+ http://localhost:8080/documentation/full-screen-with-checkmark-text.html
+ http://localhost:8080/documentation/full-screen-with-visa-blue-background-checkmark.html

**Full Screen View with Third Party confirmation page**:
+ http://localhost:8080/documentation/full-screen-with-third-party-checkmark.html



## Sizing and Layout

Integration is flexible. The sizing and placement of the animation within your page is completely up to you.

If you intend to run the animation within a "position: static" element **within the page flow**, refer to **static.html**. 

Example: add a CSS (Cascading Style Sheets) class on the Dom Element ID: ‘visa-sensory-branding’ as shown below: 

```
 #visa-sensory-branding {
     width: 400px;
     height: 398px;    
     position: static;
 }

```

If you intend to run the animation in a "position: absolute" element that runs **outside of the page flow**, refer to **absolute.html**. 

```
 #visa-sensory-branding {
       display: none;
       position: absolute;    
       top: 0px;
   }
 
  #visa-sensory-branding.show {
        display: block;
        width: 700px;
        height: 500px;
  }

```

Please ensure that the constrained container on the web is bigger than the provided dimensions below.

Minimum width | Minimum height
--- | --- |
60px | 50px  |


## Init Parameters

```
VisaSensoryBranding.init( animationConfig, brandingFolder);
```

+ animationConfig (optional): Javascript Object, Used to set animation parameters
    ```
    {
        checkmark: "checkmarkWithText",
        checkmarkTextOption: "approve",    
        color: "FFFFFF", 
        constrained: true,
        language: "en",
        sound: false
    }
    ```
+ brandingFolder (required): String, Path to the VisaSensoryBrandingSDK folder
    ```
    '../VisaSensoryBrandingSDK'
    ```

  Sample Configuration: 
    ```
         <script>
            VisaSensoryBranding.init({
                constrained: true,
                checkmark: 'checkmarkWithText',
                checkmarkTextOption: 'approve',
                color: "ffffff",
                language: "en",
                sound: false
              }, 
              '../VisaSensoryBrandingSDK'
            );
          </script>
    ```

## Animation Configuration Parameters

Parameter | Type | Description
--- | --- | --- |
sound | Boolean | Activate the audio as the animation plays. <br /> Only available in the desktop browsers, mobile devices disable the sound by default according to the Auto-play policy. <br /> * Required: no <br /> * Type: boolean <br /> * Default values: false <br /> If the wrong value is entered, no sound will be activated 
color | String | The backdrop color is the background color of the animated logo. <br /> If the backdrop color is white (#FFFFFF), a blue Visa Logo, checkmark and text will be shown. <br /> If backdrop color is #1434CB (Visa Blue), a white Visa Logo, checkmark and text will be shown. <br /> Any other color will result in either blue or white being applied to both Logo and checkmark, depending on the contrast. <br /> Please ensure that the color contrast between custom backdrop color and white/#1434CB should be at least 3:1 to be compliant with ADA (Americans with Disabilities Act). <br /> You can test the color contrast at Contrast Checker. <br /> color: "FFFFFF" <br /> * Required: no <br /> * Type: string <br /> * Default values: "white" <br /> * Available values: "hex color codes (without #) with correct color contrast (>=3)" <br /> * If the wrong value is entered, default white background color with blue visa logo will be shown <br /> * If color contrast is less than 3, the animation will still be shown with a warning message printed in the console: "Your custom color doesn't provide enough contrast. Please enter another color." 
constrained | Boolean | The constrained animation will be shown within the parent Dom Element, otherwise it will be shown in full screen. <br /> ``` constrained: true ``` <br /> * Required: no <br /> * Type: boolean <br /> Default Value: false <br /> * If the wrong value is entered, the default value (false) will be assigned to the parameter
language | String | Define the language of the texts present below the checkmark. <br /> ``` language: "en"``` <br /> * Required: no <br /> * Type: string <br /> * Default value: "en" <br /> * Example Values (ISO-639-1): <br /> ** ar <br /> ** en <br /> ** es <br /> ** zh_tw <br /> ** zh_hk <br /> ** zh_cn <br /> Please refer to “language codes available for integration” table under Appendix section. <br /> If the wrong value is entered, the text will be defaulted to English.
checkmark | String | This parameter enables/disables checkmark screen after visa logo animation <br /> Example <br /> * "none":**no** checkmark at the end of the animation <br /> * "checkmark": **shows** checkmark at the end of the animation <br /> * "checkmarkWithText": **shows** checkmark and checkmark text at the end of the animation <br /> ```checkmark: "checkmark"``` <br /> * Required: no <br /> * Type: string <br /> * Default Value: "none" <br /> * Available values: "none", "checkmark", "checkmarkWithText" <br /> * if the wrong value is entered, please refer below. <br /> * true: Checkmark is shown <br /> * false: Checkmark is not shown <br /> * Any random string: Checkmark is shown <br /> If checkmark = "checkmarkWithText" and checkmarkTextOption is not defined, checkmark will be displayed without text.
checkmarkTextOptions | String | If 'checkmark' attribute is equal to **"checkmarkWithText"**, it defines the text to render below. <br /> Available Checkmark text options <br /> * approved: Approved <br /> * success: Success <br /> * complete: Complete <br /> Attribute Name - **checkmarkTextOption <br /> ```checmarkTextOption: "approved"``` <br /> * Required: no <br /> * Type: string <br /> * Default Value: undefined <br /> * Available values: "approved, "success", "complete" <br /> * If the wrong value is entered, no text will be shown.




## Migration steps for existing users

### **STEP 1**: Download the latest web zip 

### **STEP 2**: Replace the existing /VisaSensoryBrandingSDK/ folder with the new /VisaSensoryBrandingSDK/ from the zip file

### **STEP 3**: Migrate the existing configurations

#### Initialization

##### **Original**
```
 <script>
        VisaSensoryBranding.init({
               checkmark: true,
               color: "ffffff",
               constrained: true,
               sound: false
         }, 
         '../VisaSensoryBrandingSDK');
  </script>

 ```

##### **New Changes**
```
 <script>
        VisaSensoryBranding.init({
               checkmark: 'checkmark',
               color: "ffffff",
               constrained: true,
               sound: false
         }, 
         '../VisaSensoryBrandingSDK');
  </script>
 ```

#### **Animation End Event**

##### **Original**
```
 window.addEventListener('visa-sensory-branding-end', function(e) {
       console.log(e);
  });
 ```

##### **New Changes**
```
 window.addEventListener("message", e => {
       if (e.data === 'visa-sensory-branding-end'){
            console.log(e);
       }
 });
 ```

*Note: the checkmark attribute changes from Boolean to String.



### **STEP 4**: Add the new configurations if applicable 

#### **Initialization**



##### **Original**
No text in the original animation

```
 <script>
        VisaSensoryBranding.init({
               checkmark: true,
               color: "ffffff",
               constrained: true,
               sound: false
         }, 
         '../VisaSensoryBrandingSDK');
  </script>

 ```

##### **New Changes**
Text ‘Approved’/ ‘Success’ are available to insert below the check mark icon

```
 <script>
        VisaSensoryBranding.init({
               checkmark: 'checkmarkWithText',
               checkmarkTextOption: 'approve’,
               language: 'en’,
               color: "ffffff",
             constrained: true,
               sound: false
         }, 
         '../VisaSensoryBrandingSDK');
  </script>
 ```



### Running the Animation
```
VisaSensoryBranding.show();
```

Running the animation is done via the "show" function. It will run with the parameters passed to init.

## Appendix

### Full Screen View:

Standard width | Standard height
--- | --- |
40% of the screen width | auto   |

**The width of logo will not exceed 60% of screen width**

### Constrained View: 

Standard width | Standard height
--- | --- |
90% of the constrained container | auto   |

If aspect ratio (width/height) of the constrained container is > 1.5

Standard width | Standard height
--- | --- |
135% of the constrained container height | auto   |

### Available language codes for integration:

Language Name |  | Language Code 
--- | --- | --- 
Arabic |  | ar 
English |  | en 
Spanish |  | es 
Traditional Chinese (TW) |  | zh_tw
Traditional Chinese (HK) |  | zh_hk 
Simplified Chinese |  | zh_cn  